function cb_m21
% Menu 21
% Calibrate transfer function

  global persParamsDir
  global Hcal
  global f
  global sfontsize
  global hdt

  qtext{1}='Is the setup like this:';
  qtext{2}='* MA is connected properly!';
  qtext{3}='* MA switch is set to A!';
  
  btn = questdlg (qtext, 'Setup Check!','Yes', 'No','No');

  if strcmp (btn, 'Yes')

    cancelMeasurement;
    Haux = measureH;

    if ~isempty(Haux)

      Hcal = Haux;
      sn = strcat(persParamsDir,'Hcal.mat');
      save('-mat',sn ,'Hcal');

      L=20*log10(abs(Hcal));
      P=180/pi*angle(Hcal);

      if ishandle(hdt)
          delete(hdt)
      end;

      fa=f(1);
      fb=f(end);

      subplot(2,1,1)

      semilogx(f,L)
      axis([fa fb -4 4])
      grid
      title('Hcal');
      xlabel('Frequency / Hz')
      ylabel('Gain / dB')
      ha1=gca;

      subplot(2,1,2)
      semilogx(f,P)
      axis([fa fb -20 20]);
      grid
      xlabel('Frequency / Hz')
      ylabel('Phase / degree')
      ha2=gca;

      set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);
      sn = strcat(persParamsDir,'Hcal.png');
      print('-dpng',sn,'-r300');

      set(ha1, 'fontsize',sfontsize);
      set(ha2, 'fontsize',sfontsize);

    end

  end

end
